/*
 * Decompiled with CFR 0.152.
 */
package com.xiangcao.xiangcaomengjia;

import com.xiangcao.xiangcaomengjia.config.PriceVariationClient;
import com.xiangcao.xiangcaomengjia.config.PriceVariationData;
import com.xiangcao.xiangcaomengjia.config.SellingBinConfig;
import com.xiangcao.xiangcaomengjia.config.SellingBinConfigClient;
import com.xiangcao.xiangcaomengjia.config.XiangcaoTierConfig;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="xiangcaomengjia", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class RecyclingPriceTooltipHandler {
    @SubscribeEvent
    public static void onItemTooltip(ItemTooltipEvent event) {
        long displayPrice;
        String inputItemId;
        long basePerOne;
        ItemStack stack = event.getItemStack();
        if (stack.m_41619_()) {
            return;
        }
        if (SellingBinConfigClient.hasServerTradeList()) {
            SellingBinConfigClient.TradeEntry e = SellingBinConfigClient.findTrade(stack);
            if (e == null) {
                return;
            }
            basePerOne = e.count() <= 0 ? e.price() : e.price() / (long)e.count();
            inputItemId = e.itemId();
        } else {
            SellingBinConfig.TradeRule rule = SellingBinConfig.getInstance().findTrade(stack);
            if (rule == null) {
                return;
            }
            basePerOne = rule.inputCount <= 0 ? rule.sdmValue : rule.sdmValue / (long)rule.inputCount;
            inputItemId = rule.inputItem;
        }
        long l = displayPrice = XiangcaoTierConfig.priceVariationEnabled() ? PriceVariationData.getEffectivePriceForDisplay(basePerOne, inputItemId, PriceVariationClient.getMultipliers()) : basePerOne;
        if (!XiangcaoTierConfig.showRecyclingPriceTooltip()) {
            return;
        }
        if (XiangcaoTierConfig.priceVariationEnabled()) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.xiangcaomengjia.price_variation_hint").m_130940_(ChatFormatting.GRAY));
        }
        if (XiangcaoTierConfig.supplyDropEnabled()) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.xiangcaomengjia.supply_drop_hint").m_130940_(ChatFormatting.GRAY));
        }
        if (XiangcaoTierConfig.bulkBonusEnabled()) {
            event.getToolTip().add(Component.m_237110_((String)"tooltip.xiangcaomengjia.bulk_bonus_hint", (Object[])new Object[]{XiangcaoTierConfig.bulkBonusStacks()}).m_130940_(ChatFormatting.GRAY));
        }
        if (XiangcaoTierConfig.varietyBonusEnabled()) {
            event.getToolTip().add(Component.m_237110_((String)"tooltip.xiangcaomengjia.variety_bonus_hint", (Object[])new Object[]{XiangcaoTierConfig.varietyBonusTypes()}).m_130940_(ChatFormatting.GRAY));
        }
        if (XiangcaoTierConfig.marketFeePercent() > 0.0) {
            event.getToolTip().add(Component.m_237110_((String)"tooltip.xiangcaomengjia.market_fee_hint", (Object[])new Object[]{String.format("%.1f", XiangcaoTierConfig.marketFeePercent())}).m_130940_(ChatFormatting.GRAY));
        }
        if (XiangcaoTierConfig.firstSellBonusEnabled()) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.xiangcaomengjia.first_sell_bonus_hint").m_130940_(ChatFormatting.GRAY));
        }
        if (XiangcaoTierConfig.recyclingPriceTooltipIconStyle()) {
            event.getToolTip().add(Component.m_237115_((String)"tooltip.xiangcaomengjia.recycling_price_header").m_130940_(ChatFormatting.GOLD));
            event.getToolTip().add(Component.m_237110_((String)"tooltip.xiangcaomengjia.recycling_price_value", (Object[])new Object[]{displayPrice}).m_130940_(ChatFormatting.GREEN));
        } else {
            event.getToolTip().add(Component.m_237110_((String)"tooltip.xiangcaomengjia.recycling_price_value", (Object[])new Object[]{displayPrice}).m_130940_(ChatFormatting.GREEN));
        }
    }
}

